//********************************************************************
//  Skyline.java       Author: Lewis and Loftus
//
//  Solution to Programming Project 4.8 (5E, p. 204)
//********************************************************************

import javax.swing.JApplet;
import java.awt.Graphics;
import java.awt.Color;

public class Skyline extends JApplet
{
   private final int APPLET_HEIGHT = 200;
   private final int APPLET_WIDTH = 550;
   private final int MAX_GAP = 40;
   private final int MIN_GAP = 5;

   private Building b1, b2, b3, b4, b5, b6, b7;

   //----------------------------------------------------------------
   //  Creates several Building objects.
   //----------------------------------------------------------------
   public void init ()
   {
      b1 = new Building (55, 75);
      b2 = new Building (40, 170);
      b3 = new Building ();
      b4 = new Building (75, 135);
      b5 = new Building (30, 150);
      b6 = new Building ();
      b7 = new Building (25, 100);

      setBackground (Color.cyan);
      setSize (APPLET_WIDTH, APPLET_HEIGHT);
   }

   //----------------------------------------------------------------
   //  Paints the buildings with a random size gap between them
   //----------------------------------------------------------------
   public void paint (Graphics page)
   {
      int gapVariance = MAX_GAP - MIN_GAP;
      int base = APPLET_HEIGHT - 10;
      int gap = (int) (Math.random() * gapVariance) + MIN_GAP;
      int leftSide = gap;

      page.drawLine (0, base, APPLET_WIDTH, base);

      b1.draw (page, leftSide, base);

      gap = (int) (Math.random() * gapVariance) + MIN_GAP;
      leftSide += b1.getWidth() + gap;
      b2.draw (page, leftSide, base);

      gap = (int) (Math.random() * gapVariance) + MIN_GAP;
      leftSide += b2.getWidth() + gap;
      b3.draw (page, leftSide, base);

      gap = (int) (Math.random() * gapVariance) + MIN_GAP;
      leftSide += b3.getWidth() + gap;
      b4.draw (page, leftSide, base);

      gap = (int) (Math.random() * gapVariance) + MIN_GAP;
      leftSide += b4.getWidth() + gap;
      b5.draw (page, leftSide, base);

      gap = (int) (Math.random() * gapVariance) + MIN_GAP;
      leftSide += b5.getWidth() + gap;
      b6.draw (page, leftSide, base);

      gap = (int) (Math.random() * gapVariance) + MIN_GAP;
      leftSide += b6.getWidth() + gap;
      b7.draw (page, leftSide, base);
   }
}
